#include "resolve.h"
#include <maps/wikimap/mapspro/libs/social/magic_strings.h>
#include "helpers.h"

namespace maps::wiki::social {

namespace {

const boost::format SELECT_TASKS_BY_TASK_IDS(
    "SELECT " + sql::col::EVENT_ID +
    " FROM " + sql::table::TASK_ACTIVE +
    " WHERE " + sql::col::RESOLVE_RESOLUTION + " IS NULL"
      " AND " + sql::col::LOCKED_BY + "=%1%"
      " AND " + sql::col::EVENT_ID + " IN (%2%)"
    " ORDER BY " + sql::col::EVENT_ID + " DESC FOR UPDATE");

const boost::format SELECT_TASKS_BY_TASK_IDS_NO_CHECK_OF_LOCKED(
    "SELECT " + sql::col::EVENT_ID +
    " FROM " + sql::table::TASK_ACTIVE +
    " WHERE " + sql::col::RESOLVE_RESOLUTION + " IS NULL"
      " AND " + sql::col::EVENT_ID + " IN (%2%)"
    " ORDER BY " + sql::col::EVENT_ID + " DESC FOR UPDATE");

const boost::format SELECT_EDIT_TASKS_BY_COMMIT_IDS(
    "SELECT " + sql::col::EVENT_ID +
    " FROM " + sql::table::TASK_ACTIVE +
    " WHERE " + sql::col::RESOLVE_RESOLUTION + " IS NULL"
      " AND " + sql::col::COMMIT_ID + " IN (%2%)"
      " AND " + sql::col::TYPE + "='" + sql::value::EVENT_TYPE_EDIT + "'"
    " ORDER BY " + sql::col::EVENT_ID + " DESC FOR UPDATE");

const boost::format UPDATE_TASKS_RESOLVE(
    "UPDATE " + sql::table::TASK_ACTIVE + " SET " +
        sql::col::RESOLVE_RESOLUTION + "='%1%'," +
        sql::col::RESOLVED_BY + "=%2%," +
        sql::col::RESOLVED_AT + "=" + sql::value::NOW + "," +
        sql::col::LOCKED_BY + "=0," +
        sql::col::LOCKED_AT + "=NULL"
    " WHERE " + sql::col::EVENT_ID + " IN (%3%)");

} // namespace

namespace tasks {

TaskIds
resolveByTaskIds(
    pqxx::transaction_base& work,
    TUid uid,
    ResolveResolution resolution,
    const TaskIds& taskIds)
{
    return selectAndUpdateTasks(
        work,
        uid,
        resolution,
        taskIds,
        SELECT_TASKS_BY_TASK_IDS,
        UPDATE_TASKS_RESOLVE);
}

TaskIds
resolveEditsByCommitIds(
    pqxx::transaction_base& work,
    TUid uid,
    ResolveResolution resolution,
    const TIds& commitIds)
{
    return selectAndUpdateTasks(
        work,
        uid,
        resolution,
        commitIds,
        SELECT_EDIT_TASKS_BY_COMMIT_IDS,
        UPDATE_TASKS_RESOLVE);
}

TaskIds
resolveByTaskIdsNoCheckOfLocked(
    pqxx::transaction_base& work,
    TUid uid,
    ResolveResolution resolution,
    const TaskIds& taskIds)
{
    return selectAndUpdateTasks(
        work,
        uid,
        resolution,
        taskIds,
        SELECT_TASKS_BY_TASK_IDS_NO_CHECK_OF_LOCKED,
        UPDATE_TASKS_RESOLVE);
}

} // namespace tasks

} // namespace maps::wiki::social
