#pragma once

#include <yandex/maps/wiki/social/common.h>
#include <yandex/maps/wiki/social/moderation.h>
#include <yandex/maps/wiki/social/moderation_time_intervals.h>
#include <yandex/maps/wiki/social/task_stats_console.h>

#include <pqxx/pqxx>

#include <map>
#include <optional>
#include <string>

namespace maps::wiki::social::tasks {

std::map<TId, ActiveTaskStat> activeTaskStatsByAoi(
    pqxx::transaction_base& work,
    ModerationMode mode,
    const std::optional<CategoryIdsSet>& categoryIds,
    const std::optional<EventType> eventType,
    const ModerationTimeIntervals& moderationTimeIntervals);

std::map<TId, size_t> recentNewTaskCountsByAoi(
    pqxx::transaction_base& work,
    ModerationMode mode,
    const std::optional<CategoryIdsSet>& categoryIds,
    const std::optional<EventType> eventType,
    const ModerationTimeIntervals& moderationTimeIntervals);

std::map<TId, size_t> recentProcessedTaskCountsByAoi(
    pqxx::transaction_base& work,
    ModerationMode mode,
    const std::optional<CategoryIdsSet>& categoryIds,
    const std::optional<EventType> eventType,
    const ModerationTimeIntervals& moderationTimeIntervals);

size_t todayProcessedTaskCountByUid(
    pqxx::transaction_base& work,
    TUid uid,
    int tzInMinutes);

} // namespace maps::wiki::social::tasks
