#include <yandex/maps/wiki/social/user_data.h>

#include "magic_strings.h"

namespace maps::wiki::social {

UserData::UserData(const pqxx::row& row)
    : uid_(row[sql::col::UID].as<TUid>())
    , createdAt_(chrono::parseSqlDateTime(row[sql::col::CREATED_AT].as<std::string>()))
    , modifiedAt_(chrono::parseSqlDateTime(row[sql::col::MODIFIED_AT].as<std::string>()))
    , data_(row[sql::col::DATA].as<std::string>({}))
{}

} // namespace maps::wiki::social
