#pragma once

#include <yandex/maps/wiki/social/common.h>
#include <yandex/maps/wiki/social/user_data.h>

#include <pqxx/pqxx>
#include <chrono>
#include <optional>
#include <vector>

namespace maps::wiki::social::impl {

std::optional<UserData> getUserData(
    pqxx::transaction_base& txn,
    TUid uid);

UserData setUserData(
    pqxx::transaction_base& txn,
    TUid uid,
    const std::string& data);

UserActivity getUserActivity(
    pqxx::transaction_base& txn,
    TUid uid,
    const std::vector<std::chrono::seconds>& timeIntervals,
    ActivityType type);

void saveUserActivity(
    pqxx::transaction_base& txn,
    TUid uid,
    const std::string& ip,
    std::optional<uint16_t> port,
    UserActivityAction action,
    const std::optional<TId>& entityId);

void saveUserActivityAlert(
    pqxx::transaction_base& txn,
    TUid uid,
    const std::string& reason);

} // namespace maps::wiki::social::impl
