#include <maps/wikimap/mapspro/libs/social_serv_serialize/include/jsonize_comment.h>

#include <maps/wikimap/mapspro/libs/gdpr/include/user.h>
#include <yandex/maps/wiki/common/json_helpers.h>
#include <yandex/maps/wiki/common/date_time.h>

namespace maps::wiki::socialsrv::serialize {

namespace {

const std::string STR_ID = "id";
const std::string STR_CREATED_BY = "createdBy";
const std::string STR_CREATED_AT = "createdAt";
const std::string STR_DELETED_BY = "deletedBy";
const std::string STR_DELETED_AT = "deletedAt";
const std::string STR_COMMIT_ID = "commitId";
const std::string STR_OBJECT_ID = "objectId";
const std::string STR_FEEDBACK_TASK_ID = "feedbackTaskId";
const std::string STR_COMMENT_TYPE = "type";
const std::string STR_INTERNAL = "internal";
const std::string STR_DATA = "data";

} // unnamed namespace

void
jsonize(json::ObjectBuilder& builder, const social::Comment& comment)
{
    builder[STR_ID] = common::idToJson(comment.id());
    builder[STR_CREATED_BY] = common::idToJson(gdpr::User(comment.createdBy()).uid());
    builder[STR_CREATED_AT] = common::canonicalDateTimeString(
        comment.createdAt(), common::WithTimeZone::Yes);
    if (comment.deletedBy()) {
        builder[STR_DELETED_BY] = common::idToJson(comment.deletedBy());
        builder[STR_DELETED_AT] = common::canonicalDateTimeString(
            comment.deletedAt(), common::WithTimeZone::Yes);
    }
    builder[STR_COMMIT_ID] = common::idToJson(comment.commitId());
    if (comment.objectId()) {
        builder[STR_OBJECT_ID] = common::idToJson(comment.objectId());
    }
    if (comment.feedbackTaskId()) {
        builder[STR_FEEDBACK_TASK_ID] = common::idToJson(*comment.feedbackTaskId());
    }
    builder[STR_COMMENT_TYPE] = boost::lexical_cast<std::string>(comment.type());
    builder[STR_INTERNAL] = comment.internal() == social::Comment::Internal::Yes;
    builder[STR_DATA] = comment.data();
}

} // namespace maps::wiki::socialsrv::serialize
