#include <maps/wikimap/mapspro/libs/social_serv_serialize/include/task_extended.h>
#include <yandex/maps/wiki/social/feedback/attribute_names.h>

using namespace maps::wiki::social::feedback;

namespace maps::wiki::socialsrv::serialize {

TaskExtended::TaskExtended(TaskForUI taskForUI)
    : userData(taskForUI)
    , taskForUI(std::move(taskForUI))
{
    const auto& attrs = this->taskForUI.attrs();
    if (attrs.existCustom(attrs::OBJECT_URI)) {
        objectUri = attrs.getCustom(attrs::OBJECT_URI);
    }
}

TaskExtended::TaskExtended(
        social::feedback::Task task,
        social::feedback::History history,
        SubstitutionStrategy substitutionStrategy,
        social::Comments comments,
        social::feedback::TaskOperations validOperations,
        social::TUid uid)
    : TaskExtended(TaskForUI(
        std::move(task),
        std::move(history),
        substitutionStrategy,
        std::move(comments),
        std::move(validOperations),
        uid))
{}

} // namespace maps::wiki::socialsrv::serialize
