#pragma once

#include "substitution_data.h"

#include <yandex/maps/wiki/social/comment.h>
#include <yandex/maps/wiki/social/feedback/history.h>
#include <yandex/maps/wiki/social/feedback/task.h>

#include <optional>
#include <string>
#include <vector>

namespace maps::wiki::socialsrv::serialize {

bool isJustLeveledUpByUser(
    const social::feedback::History& history, social::TUid uid);

struct HistoryEventUI
{
    HistoryEventUI(const social::feedback::HistoryItem& item): historyItem(item) {}

    social::feedback::HistoryItem historyItem;
    std::optional<social::Comment> comment;
};
using HistoryEventsUI = std::vector<HistoryEventUI>;

enum class SubstitutionStrategy
{
    ForZeroProcessingLine,
    None,
};

class TaskForUI final : public social::feedback::Task
{
public:
    TaskForUI(
        social::feedback::Task task,
        social::feedback::History history,
        SubstitutionStrategy substitutionStrategy,
        social::Comments comments,
        social::feedback::TaskOperations validOperations,
        social::TUid uid);

    const std::optional<social::feedback::TaskResolved>& resolved() const override;
    int processingLevel() const override;
    social::feedback::TaskState state() const override;

    const social::feedback::TaskOperations& validOperations() const;
    const social::feedback::RejectReasonsSet& validRejectReasons() const;
    HistoryEventsUI historyEventsUI() const;

    const social::feedback::History& history() const { return history_; }

    const std::optional<social::TId>& nearbyObjectId() const;
    void setNearbyObjectId(std::optional<social::TId> objectId);

private:
    social::feedback::History history_;
    social::Comments comments_;
    std::optional<SubstitutionData> substitutionData_;
    social::feedback::TaskOperations validOperations_;
    social::feedback::RejectReasonsSet validRejectReasons_;
    std::optional<social::TId> nearbyObjectId_;
};

using TasksForUI = std::vector<TaskForUI>;

} // namespace maps::wiki::socialsrv::serialize
