#include <maps/wikimap/mapspro/libs/sqs_client/include/client.h>
#include <maps/wikimap/mapspro/libs/sqs_client/include/configuration.h>

#include <aws/core/auth/AWSCredentialsProvider.h>

namespace maps::wiki::sqs {

Aws::SQS::SQSClient createSqsClient(const Configuration& config)
{
    Aws::Client::ClientConfiguration sqsClientConfiguration;
    sqsClientConfiguration.endpointOverride = config.getEndpoint();
    sqsClientConfiguration.scheme = Aws::Http::Scheme::HTTP;
    sqsClientConfiguration.requestTimeoutMs = 30000; // need this for long-polling

    Aws::Auth::AWSCredentials credentials;
    credentials.SetAWSAccessKeyId(config.getAccount());
    credentials.SetSessionToken(config.getOAuthToken());
    credentials.SetAWSSecretKey("unused");

    return Aws::SQS::SQSClient(credentials, sqsClientConfiguration);
}

} // namespace maps::wikimap::sqs
