#include <maps/wikimap/mapspro/libs/sqs_client/include/configuration.h>

#include <yandex/maps/wiki/common/default_config.h>
#include <yandex/maps/wiki/common/secrets.h>

namespace secrets = maps::wiki::common::secrets;

namespace maps::wiki::sqs {

namespace {

const std::string SQS_CONFIG_PATH = "/config/common/sqs/";

} // unnamed namespace


Configuration::Configuration(
    const std::string& endpoint,
    const std::string& account,
    const std::string& oAuthToken)
        : endpoint_(endpoint)
        , account_(account)
        , oAuthToken_(oAuthToken)
{
}

Configuration::Configuration(const common::ExtendedXmlDoc& servicesConfig)
    : Configuration(
          servicesConfig.get<std::string>(SQS_CONFIG_PATH + "endpoint"),
          servicesConfig.get<std::string>(SQS_CONFIG_PATH + "account"),
          secrets::tokenByKey(secrets::Key::RobotWikimapSqsToken)
      )
{
}

const std::string& Configuration::getEndpoint() const
{
    return endpoint_;
}

const std::string& Configuration::getAccount() const
{
    return account_;
}

const std::string& Configuration::getOAuthToken() const
{
    return oAuthToken_;
}

std::string Configuration::getQueueUrl(const std::string& queueName) const
{
    return "http://" + endpoint_ + "/" + account_ + "/" + queueName;
}

} // namespace maps::wikimap::sqs
