#pragma once

#include <aws/core/Aws.h>

namespace maps::wiki::sqs {

/*
 * One should instantiate this class at the top level of his application (binary).
 * Adding InitAPI and ShutdownAPI calls inside library is bad practice because
 * application may use two such libraries and it will result in multiple calls of
 * mentioned methods, which have unpredictable consequences.
 * So the proper solution is not to initialize AWS API inside library code
 * but to delegate its initializing to library clients.
 */
class AwsAPI
{
    Aws::SDKOptions options_;

public:

    AwsAPI(Aws::SDKOptions options = Aws::SDKOptions()) :
        options_(std::move(options))
    {
        Aws::InitAPI(options_);
    }

    ~AwsAPI() {
        Aws::ShutdownAPI(options_);
    }
};

} // namespace maps::wikimap::sqs
