#pragma once

#include <yandex/maps/wiki/common/extended_xml_doc.h>

#include <string>

namespace maps::wiki::sqs {

class Configuration
{
public:
    Configuration(
        const std::string& endpoint,
        const std::string& account,
        const std::string& oAuthToken);

    // Takes oAuthToken for robot-wikimap from secrets.
    //
    explicit Configuration(const common::ExtendedXmlDoc& nmapsServicesConfig);

    const std::string& getEndpoint() const;
    const std::string& getAccount() const;
    const std::string& getOAuthToken() const;

    /* Returns queue name in the form appropriate for sending
     * message with SQS client: {endpoint}/{account}/{queueName}.
     */
    std::string getQueueUrl(const std::string& queueName) const;

private:
    std::string endpoint_;
    std::string account_;
    std::string oAuthToken_;
};

} // namespace maps::wiki::sqs
