#include <maps/wikimap/mapspro/libs/stat_client/include/common.h>

#include <maps/libs/enum_io/include/enum_io.h>

namespace maps::wiki::stat_client {

constexpr maps::enum_io::Representations<Scale> SCALE_ENUM_REPRESENTATION {
    {Scale::Daily,     "d"},
    {Scale::Weekly,    "w"},
    {Scale::Monthly,   "m"},
    {Scale::Quarterly, "q"},
    {Scale::Yearly,    "y"},
    {Scale::Hourly,    "h"},
    {Scale::Minutely,  "i"},
    {Scale::Continual, "s"}
};
DEFINE_ENUM_IO(Scale, SCALE_ENUM_REPRESENTATION);

constexpr maps::enum_io::Representations<Mode> MODE_ENUM_REPRESENTATION {
    {Mode::Append,   "1"},
    {Mode::Truncate, "0"}
};
DEFINE_ENUM_IO(Mode, MODE_ENUM_REPRESENTATION);

} // namespace maps::wiki::stat_client
