#include <maps/wikimap/mapspro/libs/stat_client/include/upload.h>

#include <maps/wikimap/mapspro/libs/stat_client/include/common.h>

#include <yandex/maps/wiki/common/secrets.h>

#include <maps/libs/enum_io/include/enum_io.h>
#include <maps/libs/http/include/form_request.h>
#include <maps/libs/http/include/http.h>

#include <util/string/strip.h>
#include <util/system/env.h>

namespace maps::wiki::stat_client {

namespace {

using namespace std::literals;

namespace header {
const auto AUTHORIZATION = "Authorization"s;
const auto CONNECTION = "Connection"s;

namespace value {
const auto OAUTH_PREFIX = "OAuth "s;
} // namespace value
} // namespace header

namespace param {
const auto NAME = "name"s;
const auto SCALE = "scale"s;
const auto APPEND_MODE = "_append_mode"s;
const auto DATA = "data"s;
} // namespace param

const auto STAT_TOKEN_ENV = "STAT_TOKEN";

const auto HTTP_OK = 200;

std::string
statToken()
{
    auto token = Strip(GetEnv(STAT_TOKEN_ENV));
    if (!token.empty()) {
        return token;
    }
    return common::secrets::tokenByKey(common::secrets::Key::RobotWikimapStatToken);
}

} // namespace


Uploader::Uploader(std::string statUploadApiUrl):
    statUploadApiUrl_(std::move(statUploadApiUrl))
{}


Uploader&
Uploader::mode(Mode mode)
{
    mode_ = mode;
    return *this;
}


Uploader&
Uploader::timeout(std::chrono::seconds timeout)
{
    timeout_ = timeout;
    return *this;
}


void
Uploader::upload(
    const std::string& reportName,
    const std::string& reportBody,
    Scale scale)
{
    http::Client client;
    client.setTimeout(timeout_);

    http::FormRequest request(client, http::POST, statUploadApiUrl_);

    request.addHeader(header::AUTHORIZATION, header::value::OAUTH_PREFIX + statToken());

    request[param::NAME] = reportName;
    request[param::SCALE] = std::string(toString(scale));
    request[param::APPEND_MODE] = std::string(toString(mode_));
    request[param::DATA] = reportBody;

    auto response = request.perform();
    if (response.status() != HTTP_OK) {
        throw ReportUploadError() <<
            "Failed to upload report '" << reportName << "' "
            "to: " << statUploadApiUrl_ << ", response:\n" << response.readBody();
    }
}

} // namespace maps::wiki::stat_client
