#pragma once

#include <maps/libs/common/include/exception.h>
#include <maps/libs/enum_io/include/enum_io_fwd.h>

namespace maps::wiki::stat_client {

enum class Scale {
    Daily,
    Weekly,
    Monthly,
    Quarterly,
    Yearly,
    Hourly,
    Minutely,
    Continual
};
DECLARE_ENUM_IO(Scale);

enum class Mode {
    Append,   ///< Appends data to the scale (rewrites already added information).
    Truncate  ///< Removes data from the scale before adding new data.
};
DECLARE_ENUM_IO(Mode);

struct ReportUploadError: public RuntimeError {
    using RuntimeError::RuntimeError;
};

} // namespace maps::wiki::stat_client
