#include "yandex/maps/wiki/tasks/common.h"

#include <maps/libs/enum_io/include/enum_io.h>

namespace maps::wiki::tasks {

constexpr maps::enum_io::Representations<TaskStatus> TASK_STATUS_ENUM_REPRESENTATION {
    { TaskStatus::InProgress, "STARTED" },
    { TaskStatus::Frozen, "FROZEN" },
    { TaskStatus::Success, "SUCCESS" },
    { TaskStatus::Failed, "FAILURE" },
    { TaskStatus::Revoked, "REVOKED" },
};

DEFINE_ENUM_IO(TaskStatus, TASK_STATUS_ENUM_REPRESENTATION);

} // namespace maps::wiki::tasks
