#include <yandex/maps/wiki/tasks/database.h>

namespace maps::wiki::tasks {

DatabaseLock::DatabaseLock(std::string connStr)
    : connStr_(std::move(connStr))
    , conn_(connStr_)
    , work_(conn_)
{}

bool DatabaseLock::tryLock(int64_t lockId)
{
    auto query =
        "SELECT pg_catalog.pg_try_advisory_xact_lock(" + std::to_string(lockId) + ")";
    return work_.exec1(query).front().as(false);
}

} // namespace maps::wiki::tasks
