#pragma once

#include <chrono>
#include <condition_variable>
#include <functional>

namespace maps::wiki::tasks {

class Runner
{
public:
    Runner();

    void run(
        std::function<void()> f,
        std::chrono::seconds sleepTime) const;

    static void stop();

private:
    static void onStop(int);

    static volatile bool& stopping();
    static std::condition_variable& cv();
};

} // namespace maps::wiki::tasks
