#pragma once

#include <yandex/maps/wiki/revision/branch.h>

#include <pqxx/pqxx>

namespace maps {
namespace wiki {
namespace tasks {

void publishBranch(
    pqxx::transaction_base& workCore,
    pqxx::transaction_base& workLabels,
    const revision::Branch& branchToPublish,
    revision::UserID uid);

void deleteBranch(
    pqxx::transaction_base& workCore,
    pqxx::transaction_base& workView,
    const revision::Branch& branchToDelete,
    revision::UserID uid);

void deleteVrevisionsForBranch(
    pqxx::transaction_base& workLabels,
    const revision::Branch& branchToDelete);

} // namespace tasks
} // namespace wiki
} // namespace maps
