#pragma once

#include <maps/libs/enum_io/include/enum_io_fwd.h>
#include <string>

namespace maps::wiki::tasks {

using BranchId = uint64_t;
using ObjectId = uint64_t;
using CommitId = uint64_t;
using UserId = uint64_t;
using TaskId = uint64_t;
using PresetId = uint64_t;
using Token = std::string;

enum class FrozenState
{
    NotFrozen,
    Frozen
};

enum class TaskStatus
{
    InProgress,
    Frozen,
    Success,
    Failed,
    Revoked,
};

DECLARE_ENUM_IO(TaskStatus);

} // namespace maps::wiki::tasks
