#pragma once

#include <pqxx/pqxx>
#include <string>

namespace maps::wiki::tasks {

class DatabaseLock
{
public:
    explicit DatabaseLock(std::string connStr);

    const std::string& connStr() const { return connStr_; }

    bool tryLock(int64_t lockId);

private:
    std::string connStr_;
    pqxx::connection conn_;
    pqxx::work work_;
};

} // namespace maps::wiki::tasks
