#pragma once

#include <yandex/maps/wiki/tasks/database.h>
#include <yandex/maps/wiki/common/extended_xml_doc.h>
#include <memory>

namespace maps::wiki::tasks {

const std::string& getConfigExportXpath();

std::string defaultExportDatabase(const common::ExtendedXmlDoc& config);

std::string detectNearestExportDatabase(const common::ExtendedXmlDoc& config);

std::unique_ptr<DatabaseLock> detectAndLockNearestExportDatabase(
    const common::ExtendedXmlDoc& config, int64_t lockId);

} // namespace maps::wiki::tasks
