#pragma once

#include <yandex/maps/wiki/tasks/common.h>
#include <maps/libs/pgpool/include/pgpool3.h>
#include <atomic>
#include <chrono>

namespace maps::wiki::tasks {

/**
Class for checking if a task has revoked status in the database.
Performs checks not more often than once in a VALUE_DIRTY_TIME.
*/
class RevocationChecker final
{
public:
    RevocationChecker(pgpool3::Pool& pool, TaskId taskId);

    bool isTaskRevoked();

    auto wrapIntoCallable()
    {
        return [this] { return isTaskRevoked(); };
    }

private:
    using Clock = std::chrono::steady_clock;
    using TimePoint = std::chrono::time_point<Clock>;

    void update();

    pgpool3::Pool& pool_;
    TaskId taskId_;

    std::atomic<bool> lastValue_ = false;
    TimePoint nextUpdateTime_ = Clock::now();

    std::atomic_flag isUpdating_ = ATOMIC_FLAG_INIT;
};

} // namespace maps::wiki::tasks
