#pragma once

#include <optional>
#include <string>

namespace maps {
namespace wiki {
namespace tasks {

/**
 * Write status for monrun into file.
 *
 * Examples:
 * 0;OK
 * 1;WARN: Something wrong. WARN: Object with id 123 not found.
 * 2;ERR: Job failed. WARN: Object with id 123 not found.
 */

class StatusWriter
{
public:
    enum class StatusValue
    {
        OK = 0,
        WARN = 1,
        ERR = 2
    };

    explicit StatusWriter(std::optional<std::string> filepath);

    void reinit(const std::string& dirname, const std::string& filename);

    /// save warning message in memory
    void warn(const std::string& message);

    /// save error message in memory
    void err(const std::string& message);

    /// write all saved messages into file
    bool flush();

    /// reset all saved messages
    void reset();

private:
    void setMessage(StatusValue statusValue, const std::string& message);

    std::optional<std::string> filepath_;
    std::string statusMessage_;
    StatusValue maxStatusValue_ {StatusValue::OK};
};

} //namespace tasks
} //namespace wiki
} //namespace maps
