#pragma once

#include <yandex/maps/wiki/tasks/common.h>
#include <maps/libs/xml/include/xml.h>

#include <string>
#include <list>

namespace maps {
namespace wiki {
namespace tasks {

class TaskInfo;
using TaskInfos = std::list<TaskInfo>;

class TaskInfo
{
public:
    explicit TaskInfo(const maps::xml3::Node& node, Token token = {});

    static TaskInfo fromXml(const std::string& xml);
    static TaskInfos listFromXml(const std::string& xml);

    TaskId id() const { return id_; }
    TaskStatus status() const { return status_; }
    const std::string& type() const { return type_; }
    const std::string& createdAt() const { return createdAt_; }
    const Token& token() const { return token_; }

private:
    TaskId id_;
    TaskStatus status_;
    std::string type_;
    std::string createdAt_;
    Token token_;
};

} // namespace tasks
} // namespace wiki
} // namespace maps
