#pragma once

#include <maps/libs/pgpool/include/pgpool3.h>

#include <string>

namespace maps {
namespace wiki {
namespace tasks {

typedef uint64_t TaskId;

enum class Severity {
    Info,
    Warn,
    Error
};

class TaskPgLogger;

class Message
{
public:
    Message(TaskPgLogger& logger, Severity severity);
    ~Message();

    Message(Message&&) = default;
    Message& operator=(Message&&) = default;

    template <typename T>
    Message& operator<< (const T& val);

private:
    std::ostringstream buf_;
    Severity severity_;
    TaskPgLogger& logger_;
};

template <typename T>
Message& Message::operator<< (const T& val) {
    buf_ << val;
    return *this;
}

/**
 * @brief Provides task logging capability
 * to Postgres table 'service.task'
 * Usage example: logger.logInfo() << "message";
 */
class TaskPgLogger
{
public:
    TaskPgLogger(
        maps::pgpool3::Pool& pgPool,
        TaskId taskId
    );

    Message logInfo();
    Message logWarn();
    Message logError();

private:
    friend class Message;
    void log(const std::string& str);

    maps::pgpool3::Pool& pgPool_;
    const TaskId taskId_;
};

} // namespace tasks
} // namespace wiki
} // namespace maps
