#pragma once

#include <yandex/maps/wiki/common/string_utils.h>
#include <util/system/env.h>

#include <iosfwd>
#include <set>
#include <string>

namespace maps {
namespace wiki {
namespace tasks {

const std::string EDITOR_TOOL_PATH = "/usr/lib/yandex/maps/wiki/bin/wiki-editor-tool";
const TString ENV_EDITOR_TOOL_PATH = "EDITOR_TOOL_PATH";

enum class SyncStage
{
    ViewAttrs,
    Labels,
    Bboxes
};

std::string computeStagesStr(const std::set<SyncStage> stages);

void runCommandInShell(const std::string& command);

template <typename Container>
std::string getRefreshCmd(
    const Container& commitIds,
    uint64_t branchId,
    const std::string& configPath,
    const std::string& stagesStr)
{
    std::ostringstream cmd;
    const auto envToolPath = GetEnv(ENV_EDITOR_TOOL_PATH);
    cmd <<
        (envToolPath.empty()
            ? EDITOR_TOOL_PATH : envToolPath)
        << " --log-level=info"
        << " --branch=" << branchId
        << " --commits=" << common::join(commitIds, ",")
        << " --set-progress-state=0"
        << " --branch-exclusive-lock=0"
        << " --config=" << configPath
        << " --stages=" << stagesStr;

    return cmd.str();
}

/**
Run editor-tool to refresh views (labels, srv_attrs, bboxes) in the given branch
*/
template <typename Container>
void refreshViews(
    const Container& commitIds,
    uint64_t branchId,
    const std::string& configPath,
    const std::set<SyncStage> stages = {})
{
    runCommandInShell(
        getRefreshCmd(
            commitIds,
            branchId,
            configPath,
            computeStagesStr(stages)));
}

} // namespace tasks
} // namespace wiki
} // namespace maps
