#include <yandex/maps/wiki/tasks/tool_commands.h>

#include <maps/libs/common/include/exception.h>
#include <yandex/maps/shell_cmd.h>
#include <yandex/maps/shellcmd/logging_ostream.h>
#include <maps/libs/log8/include/log8.h>

namespace maps {
namespace wiki {
namespace tasks {

using namespace std::string_literals;

std::string computeStagesStr(const std::set<SyncStage> stages)
{
    if (stages.empty()) {
        return "all"s;
    }
    std::vector<std::string> stagesStr;
    if (stages.count(SyncStage::ViewAttrs)) {
        stagesStr.push_back("view,attrs"s);
    }
    if (stages.count(SyncStage::Labels)) {
        stagesStr.push_back("labels"s);
    }
    if (stages.count(SyncStage::Bboxes)) {
        stagesStr.push_back("bbox"s);
    }
    return common::join(stagesStr, ',');
}

void runCommandInShell(const std::string& command)
{
    shell::stream::LoggingOutputStream loggedOut(
        [](const std::string& s){ INFO() << "shell.stdout: " << s; });
    shell::stream::LoggingOutputStream loggedErr(
        [](const std::string& s){ INFO() << "shell.stderr: " << s; });

    shell::ShellCmd cmd(command, loggedOut, loggedErr);
    auto exitCode = cmd.run();
    REQUIRE(exitCode == 0, "Shell command failed: " << command);
}

} // namespace tasks
} // namespace wiki
} // namespace maps
