#include <yandex/maps/wiki/tasks/yt.h>
#include <yandex/maps/wiki/common/default_config.h>
#include <yandex/maps/wiki/common/yt.h>
#include <sstream>
#include <vector>

namespace maps::wiki::tasks::yt {

namespace {

const std::vector<TString> POSTGRESQL_KEYS = {
    "POSTGRESQL_MAPSPRO",
    "POSTGRESQL_MAPSPRO_MDB",
    "POSTGRESQL_STAT",
};

} // namespace

std::unique_ptr<common::ExtendedXmlDoc> loadConfigFromEnvironment(
    const std::string& environment)
{
    maps::vault_boy::MemoryContext context;
    for (const auto& key : POSTGRESQL_KEYS) {
        context.add(key, common::yt::getSecureVaultValue(key));
    }
    return common::loadDefaultConfigFromResource(environment, context);
}

void saveTaskOperationId(pgpool3::Pool& pool, TaskId taskId, NYT::TOperationId operationId)
{
    std::ostringstream query;
    auto txn = pool.masterWriteableTransaction();
    query << "UPDATE service.task SET yt_operation_id = "
        << txn->quote(GetGuidAsString(operationId).c_str())
        << " WHERE id = " << taskId;
    txn->exec(query.str());
    txn->commit();
}

} // namespace maps::wiki::tasks::yt
