#pragma once

#include <maps/wikimap/mapspro/libs/taskutils/include/common.h>
#include <maps/wikimap/mapspro/libs/taskutils/include/task.h>
#include <maps/wikimap/mapspro/libs/taskutils/include/taskresult.h>

#include <boost/noncopyable.hpp>

namespace maps::wiki::taskutils {

class Token;

class Reader : public boost::noncopyable {
public:
    explicit Reader(const std::string& dbSchema) : dbSchema_(dbSchema) {}

    /// check expires (token and db) and load fields: status, result, error_message
    TaskResult load(Transaction& work, const Token& token) const;

    /// check expires (db only) and load fields: status, result, error_message
    TaskResult load(Transaction& work, TaskID id) const;

private:
    std::string dbSchema_;
};


} // namespace maps::wiki::taskutils
