#include <maps/wikimap/mapspro/libs/taskutils/include/taskinfo.h>

namespace maps::wiki::taskutils {

namespace {
const std::string EMPTY_METADATA = "{}";
} // namespace

class TaskInfoImpl {
public:
    TaskInfoImpl(
        const std::string& serviceName,
        const std::string& taskName,
        const std::string& inputData,
        const std::string& metadataJson)
        : serviceName_(serviceName)
        , taskName_(taskName)
        , inputData_(inputData)
        , metadataJson_(metadataJson)
    {
    }

    const std::string& serviceName() const { return serviceName_; }
    const std::string& taskName() const { return taskName_; }
    const std::string& inputData() const { return inputData_; }
    const std::string& metadataJson() const { return metadataJson_; }

private:
    std::string serviceName_;
    std::string taskName_;
    std::string inputData_;
    std::string metadataJson_;
};

TaskInfo::TaskInfo(
    const std::string& serviceName,
    const std::string& taskName,
    const std::string& inputData)
    : impl_(new TaskInfoImpl(serviceName, taskName, inputData, EMPTY_METADATA))
{
}

TaskInfo::TaskInfo(
    const std::string& serviceName,
    const std::string& taskName,
    const std::string& inputData,
    const std::string& metadataJson)
    : impl_(new TaskInfoImpl(serviceName, taskName, inputData,
        metadataJson.empty()
            ? EMPTY_METADATA
            : metadataJson))
{
}

TaskInfo::~TaskInfo()
{
}

std::string
TaskInfo::serviceName() const
{
    return impl_->serviceName();
}

std::string
TaskInfo::taskName() const
{
    return impl_->taskName();
}

std::string
TaskInfo::inputData() const
{
    return impl_->inputData();
}

std::string
TaskInfo::metadataJson() const
{
    return impl_->metadataJson();
}

} // namespace maps::wiki::taskutils
