#include <maps/wikimap/mapspro/libs/taskutils/impl/taskmanager_impl.h>

#include <maps/wikimap/mapspro/libs/taskutils/impl/tasks_impl.h>

namespace maps::wiki::taskutils {

TaskManagerImpl::TaskManagerImpl(const std::string& tokenSecretWord, const std::string& dbSchema)
    : tokenSecretWord_(tokenSecretWord)
    , commonData_(new TasksCommonData(dbSchema))
{
}

Task
TaskManagerImpl::createTask(const TaskInfo& taskInfo, const Token& token) const
{
    std::shared_ptr<TaskImpl> impl(new TaskImpl(commonData_, taskInfo, token));
    return Task(impl);
}

TaskResult
TaskManagerImpl::createTaskResult(TaskStatus status, const std::string& data)
{
    std::shared_ptr<TaskResultImpl> ret(new TaskResultImpl(status, data));
    return TaskResult(ret);
}

TaskResult
TaskManagerImpl::createTaskResult(
    const std::string& status, const std::string& result, const std::string& errorMessage)
{
    std::shared_ptr<TaskResultImpl> ret(new TaskResultImpl(status, result, errorMessage));
    return TaskResult(ret);
}

} // namespace maps::wiki::taskutils
