#pragma once

#include <maps/wikimap/mapspro/libs/taskutils/include/common.h>
#include <maps/wikimap/mapspro/libs/taskutils/include/task.h>
#include <maps/wikimap/mapspro/libs/taskutils/include/taskresult.h>

#include <string>
#include <memory>

#include <boost/noncopyable.hpp>


namespace maps::wiki::taskutils {

class Token;
class TaskInfo;
class TasksCommonData;

class TaskManagerImpl {
public:
    TaskManagerImpl(const std::string& tokenSecretWord, const std::string& dbSchema);

    Task createTask(const TaskInfo& taskInfo, const Token& token) const;

    static TaskResult createTaskResult(TaskStatus status, const std::string& data = "");
    static TaskResult createTaskResult(
        const std::string& status, const std::string& result, const std::string& errorMessage);


    std::string tokenSecretWord_;
    std::shared_ptr<TasksCommonData> commonData_;
};


template <typename Transaction>
class TransactionAutoCleaner : public boost::noncopyable {
public:
    explicit TransactionAutoCleaner(Transaction& work)
        : work_(work)
        , endTransaction_(true)
    {
    }

    ~TransactionAutoCleaner()
    {
        if (endTransaction_) {
            work_.abort();
        }
    }

    void commit()
    {
        if (endTransaction_) {
            work_.commit();
            endTransaction_ = false;
        }
    }

private:
    Transaction& work_;
    bool endTransaction_;
};

} // namespace maps::wiki::taskutils
