#include <maps/wikimap/mapspro/libs/taskutils/include/taskresult.h>

#include <maps/wikimap/mapspro/libs/taskutils/impl/tasks_impl.h>

namespace maps::wiki::taskutils {

namespace {
const std::string EMPTY_STRING;
} // namespace

TaskResult::TaskResult()
    : impl_(new TaskResultImpl())
{
}

TaskResult::TaskResult(std::shared_ptr<TaskResultImpl> impl)
    : impl_(impl)
{
}

TaskResult::~TaskResult()
{
}

TaskStatus
TaskResult::status() const
{
    return impl_->status();
}

const std::string&
TaskResult::statusStr() const
{
    return impl_->statusStr();
}

const std::string&
TaskResult::result() const
{
    if (impl_->status() == TaskStatus::Done) {
        return impl_->data();
    }
    return EMPTY_STRING;
}

const std::string&
TaskResult::errorMessage() const
{
    if (impl_->status() == TaskStatus::Failed) {
        return impl_->data();
    }
    return EMPTY_STRING;
}

} // namespace maps::wiki::taskutils
