#pragma once

#include <maps/wikimap/mapspro/libs/taskutils/include/common.h>
#include <maps/wikimap/mapspro/libs/taskutils/include/taskinfo.h>
#include <maps/wikimap/mapspro/libs/taskutils/include/token.h>

#include <string>
#include <set>
#include <memory>
#include <mutex>

#include <boost/noncopyable.hpp>

namespace maps::wiki::taskutils {

class TasksCommonData : public boost::noncopyable {
public:
    explicit TasksCommonData(const std::string& dbSchema);

    const std::string& dbSchema() const { return dbSchema_; }

    void registerTask(const Token& token);
    void unregisterTask(const Token& token);

    void swapTasks(std::set<TaskID>& ids);

private:
    std::mutex mutex_;
    std::set<TaskID> ids_;
    std::string dbSchema_;
};


class TaskResultImpl : public boost::noncopyable {
public:
    TaskResultImpl() : status_(TaskStatus::Unknown) {}
    TaskResultImpl(TaskStatus status, const std::string &data);
    TaskResultImpl(
        const std::string &status,
        const std::string &result, const std::string &errMsg);

    TaskStatus status() const { return status_; }
    const std::string& statusStr() const;

    const std::string& data() const { return data_; }

private:
    TaskStatus status_;
    std::string data_;
};

class TaskImpl {
public:
    TaskImpl(std::shared_ptr<TasksCommonData> commonData, const TaskInfo& info, const Token& token);
    ~TaskImpl();

    const TaskInfo& info() const { return info_; }
    const Token& token() const { return token_; }

    const TasksCommonData& commonData() const { return *commonData_; }

private:
    std::shared_ptr<TasksCommonData> commonData_;
    TaskInfo info_;
    Token token_;
};

} // namespace maps::wiki::taskutils
