#pragma once

#include <maps/libs/common/include/exception.h>

namespace maps::wiki::taskutils {

class ExpiredException : public maps::Exception {
public:
    virtual ~ExpiredException() {}

    virtual const char* type() { return "TaskUtils: expired exception"; }
};

class WrongEmptyTimeoutException : public maps::Exception {
public:
    virtual ~WrongEmptyTimeoutException() {}

    virtual const char* type() { return "TaskUtils: wrong empty timeout exception"; }
};

class InvalidTokenException : public maps::Exception {
public:
    virtual ~InvalidTokenException() {}

    virtual const char* type() { return "TaskUtils: invalid token exception"; }
};

class InvalidResponseException : public maps::Exception {
public:
    virtual ~InvalidResponseException() {}

    virtual const char* type() { return "TaskUtils: invalid response exception"; }
};

class UnknownStatusException : public maps::Exception {
public:
    virtual ~UnknownStatusException() {}

    virtual const char* type() { return "TaskUtils: unknown status exception"; }
};

} // namespace maps::wiki::taskutils
