#pragma once

#include <maps/wikimap/mapspro/libs/taskutils/include/common.h>
#include <maps/wikimap/mapspro/libs/taskutils/include/taskresult.h>

#include <memory>

#include <pqxx/pqxx>

namespace maps::wiki::taskutils {

class Token;
class TaskInfo;
class TaskManagerImpl;
class TaskImpl;

typedef pqxx::transaction_base Transaction;


class Task {
public:
    ~Task();

    TaskID id() const;
    const TaskInfo& info() const;
    const Token& token() const;

    /// check expires and load fields: status, result, error_message
    TaskResult load(Transaction& work) const;

    /// check expires and try start task
    /// returns: Unknown, Expired, Started
    TaskResult start(Transaction& work) const;

    /// check expires and try finish task and set result
    /// returns: Unknown, Expired, Done
    TaskResult finish(Transaction& work, const std::string& result) const;

    /// stop task and set error message
    /// returns: Unknown, Failed
    TaskResult fail(Transaction& work, const std::string& errorMessage) const;

private:
    friend class TaskManagerImpl;
    explicit Task(std::shared_ptr<TaskImpl> impl);

    std::shared_ptr<TaskImpl> impl_;
};

} // namespace maps::wiki::taskutils
