#pragma once

#include <maps/wikimap/mapspro/libs/taskutils/include/common.h>

#include <string>
#include <memory>

namespace maps::wiki::taskutils {

class TaskInfoImpl;

class TaskInfo {
public:
    TaskInfo(
        const std::string& serviceName,
        const std::string& taskName,
        const std::string& inputData);
    TaskInfo(
        const std::string& serviceName,
        const std::string& taskName,
        const std::string& inputData,
        const std::string& metadataJson);

    ~TaskInfo();

    std::string serviceName() const;
    std::string taskName() const;
    std::string inputData() const;
    std::string metadataJson() const;

private:
    std::shared_ptr<TaskInfoImpl> impl_;
};

} // namespace maps::wiki::taskutils
