#pragma once

#include <maps/wikimap/mapspro/libs/taskutils/include/common.h>

#include <string>
#include <memory>

namespace maps::wiki::taskutils {

class TaskResultImpl;
class TaskManagerImpl;

class TaskResult {
public:
    TaskResult();
    ~TaskResult();

    TaskStatus status() const;
    const std::string& statusStr() const;

    const std::string& result() const;
    const std::string& errorMessage() const;

private:
    friend class TaskManagerImpl;
    explicit TaskResult(std::shared_ptr<TaskResultImpl> impl);

private:
    std::shared_ptr<TaskResultImpl> impl_;
};

} // namespace maps::wiki::taskutils
