#pragma once

#include <maps/wikimap/mapspro/libs/taskutils/include/common.h>

#include <string>
#include <ctime>
#include <memory>

namespace maps::wiki::taskutils {

class TokenImpl;

class Token {
public:
    /// Creator
    Token(TaskID id, TUid uid, time_t expires, const std::string& secretWord);

    /// Parse and check
    Token(const std::string& str, const std::string& secretWord);

    ~Token();

    TaskID id() const;
    TUid uid() const;
    time_t expires() const;

    std::string str() const;

    bool expired() const;
    void checkExpires() const;

private:
    std::shared_ptr<TokenImpl> impl_;
};

} // namespace maps::wiki::taskutils
