CREATE SCHEMA service;
SET search_path = service,public;

CREATE SEQUENCE taskutils_tasks_seq
  INCREMENT 1
  MINVALUE 1
  MAXVALUE 9223372036854775807
  START 1
  CACHE 1;

CREATE TYPE taskutils_task_state AS ENUM (
  'created',
  'started',
  'done',
  'failed',
  'canceled',
  'terminated'
);

CREATE TABLE taskutils_tasks
(
  id bigint NOT NULL DEFAULT nextval('taskutils_tasks_seq'::regclass),
  service_name character varying(255) DEFAULT '',
  task_name character varying(255) DEFAULT '',
  expires timestamp without time zone NOT NULL,
  status taskutils_task_state NOT NULL DEFAULT 'created',
  created timestamp without time zone DEFAULT now(),
  created_by bigint not null DEFAULT 0,
  finished timestamp without time zone,
  input_data text DEFAULT '' NOT NULL,
  result text DEFAULT '' NOT NULL,
  error_message text DEFAULT '' NOT NULL,
  metadata_json jsonb DEFAULT '{}' NOT NULL,
  CONSTRAINT taskutils_tasks_pkey PRIMARY KEY(id)
);
ALTER SEQUENCE taskutils_tasks_seq OWNED BY taskutils_tasks.id;


CREATE INDEX taskutils_tasks_created_by_uid ON taskutils_tasks USING btree(created_by);
CREATE INDEX taskutils_tasks_created_date ON taskutils_tasks USING btree(created);
CREATE INDEX taskutils_tasks_expires_date ON taskutils_tasks USING btree(expires);
CREATE INDEX taskutils_tasks_status_type ON taskutils_tasks USING btree(status);
CREATE INDEX taskutils_tasks_task_name ON taskutils_tasks USING btree(task_name);
CREATE INDEX taskutils_tasks_service_name ON taskutils_tasks USING btree(service_name);
CREATE INDEX taskutils_tasks_metadata_json_path_ops ON taskutils_tasks USING gin(metadata_json jsonb_path_ops) WITH (fastupdate=off);
