#pragma once
#include "tf_inferencer.h"

#include <maps/libs/common/include/exception.h>

#include <opencv2/opencv.hpp>
#include <tensorflow/core/public/session.h>

#include <string>
#include <vector>

namespace maps {
namespace wiki {
namespace tf_inferencer {

struct FasterRCNNResult {
    FasterRCNNResult(const cv::Rect& _bbox, int _classID, float _confidence)
        : bbox(_bbox)
        , classID(_classID)
        , confidence(_confidence)
    {}
    cv::Rect bbox;
    int      classID;
    float    confidence;
};

typedef std::list<FasterRCNNResult> FasterRCNNResults;

class FasterRCNNInferencer {
public:
    /**
    * @param path to tensorflow model in protobuf format
    */
    FasterRCNNInferencer(const std::string& path);
    static FasterRCNNInferencer fromResource(const std::string& resourceName);
    FasterRCNNInferencer(const tensorflow::GraphDef& graphDef);
    FasterRCNNInferencer(TensorFlowInferencer&& inferencer);

    FasterRCNNResults
    inference(const cv::Mat &inputImage, float scoreThreshold) const;

    std::vector<FasterRCNNResults>
    inference(const ImagesBatch &inputImagesBatch, float scoreThreshold) const;
private:
    TensorFlowInferencer inferencer_;
};


} //namespace tf_inferencer
} //namespace wiki
} //namespace maps
