#pragma once
#include "tf_inferencer.h"

#include <maps/libs/common/include/exception.h>

#include <opencv2/opencv.hpp>
#include <tensorflow/core/public/session.h>

#include <string>
#include <vector>

namespace maps {
namespace wiki {
namespace tf_inferencer {

class SemSegmInferencer {
public:
    /**
    * @param path to tensorflow model in protobuf format
    */
    SemSegmInferencer(const std::string& path);
    static SemSegmInferencer fromResource(const std::string& resourceName);
    SemSegmInferencer(const tensorflow::GraphDef& graphDef);
    SemSegmInferencer(TensorFlowInferencer&& inferencer);

    cv::Mat inference(const cv::Mat &inputImage) const;

    ImagesBatch inference(const ImagesBatch &inputImagesBatch) const;
private:
    TensorFlowInferencer inferencer_;
};


} //namespace tf_inferencer
} //namespace wiki
} //namespace maps
