#pragma once

#include "opencv2/opencv.hpp"
#include <tensorflow/core/lib/io/record_writer.h>

#include <util/stream/output.h>

#include <list>
#include <memory>

namespace maps {
namespace wiki {
namespace tfrecord_writer {

struct FasterRCNNObject {
    int label;
    std::string text;
    // bbox coordinates in pixels
    cv::Rect bbox;
};

typedef std::list<FasterRCNNObject> FasterRCNNObjects;

struct MaskRCNNObject {
    int label;
    std::string text;
    // bbox coordinates in pixels
    cv::Rect bbox;
    // Whole-image binary mask for object instance.
    // The spatial dimensions of mask must agree with the image.
    // Mask has only a single channel, and the pixel values are
    // either 0 (background) or 1 (object mask)
    cv::Mat mask;
};

typedef std::list<MaskRCNNObject> MaskRCNNObjects;

struct MultiLabelsObject {
    std::list<int64_t> labels;
    std::string text;
    // bbox coordinates in pixels
    cv::Rect bbox;
};

typedef std::list<MultiLabelsObject> MultiLabelsObjects;

template <typename Object>
class TFRecordWriter {
public:
    TFRecordWriter(IOutputStream *stream);
    /*
     * Add record to destination file.
     * Image is load from imagepath and will encode to jpeg format.
    */
    void AddRecord(const std::string &imagepath, const std::list<Object> &objects);

    /*
     * Add record to destination file.
     * Image will encode to jpeg format.
    */
    void AddRecord(const cv::Mat &image, const std::list<Object> &objects, const std::string &filename = "");

    /*
     * Add record to destination file.
     * encimage - encoded image.
     * image will reencode anyway
    */
    void AddRecord(const std::vector<std::uint8_t> &encimage, const std::list<Object> &objects, const std::string &filename = "");

    void Flush();
public:
    size_t GetRecordsCount() const {
        return recordsCount_;
    }
    size_t GetObjectsCount() const {
        return objectsCount_;
    }
private:
    std::shared_ptr<tensorflow::io::RecordWriter> writer_;
    size_t recordsCount_;
    size_t objectsCount_;
};

} // namespace tfrecord_writer
} // namespace wiki
} // namespace maps
