#pragma once

#include <yandex/maps/wiki/threadutils/threadpool.h>

#include <memory>

namespace maps::wiki {

// Class for tasks execution with assistance of thread pool.
// Usage: add some tasks and call executeAll() in the same thread.
class Executor
{
public:
    Executor();
    ~Executor();

    void addTask(ThreadPool::Functor task);

    // use current thread
    void executeAll(ThreadPool& pool);

    // don't use current thread
    void executeAllInThreads(ThreadPool& pool);

private:
    class Impl;
    std::unique_ptr<Impl> impl_;
};

} // namespace maps::wiki
