#pragma once

#include <memory>
#include <functional>

namespace maps::wiki {

class ThreadPool {
public:
    using Functor = std::function<void ()>;

    explicit ThreadPool(size_t threads);
    ~ThreadPool();

    ThreadPool(ThreadPool&&) noexcept;

    // Queues task for execution.
    // Returns false if stopped/shut down.
    bool push(Functor f);

    size_t threadsCount() const;
    size_t activeTasksCount() const;
    size_t pendingTasksCount() const;

    // Disallows accepting new tasks, blocks until all tasks are finished.
    void shutdown();
    // Disallows accepting new tasks, aborts all pending tasks, non-blocking.
    void stop();

private:
    class Impl;
    std::unique_ptr<Impl> impl_;
};

} // namespace maps::wiki
