#pragma once

#include "operation.h"
#include "../events_data.h"

#include <yandex/maps/wiki/topo/editor.h>

#include <maps/libs/geolib/include/point.h>

namespace maps {
namespace wiki {
namespace topo {

class CreateIntersectionsOperation : public Operation {
public:
    CreateIntersectionsOperation(
        const Callbacks& callbacks,
        CacheImpl& cache,
        const geolib3::PolylinesVector& geoms,
        const TopologyRestrictions& restrictions);

    Editor::CreateIntersectionsResult operator () ();

private:
    geolib3::PolylinesVector geoms_;
    const TopologyRestrictions restrictions_;
};

} // namespace topo
} // namespace wiki
} // namespace maps
