#pragma once

#include "operation.h"
#include "../events_data.h"

#include <yandex/maps/wiki/topo/editor.h>

namespace maps {
namespace wiki {
namespace topo {

class Edge;
class Node;

class MoveNodeOperation : public Operation {
public:
    MoveNodeOperation(
        const Callbacks& callbacks,
        CacheImpl& cache,
        const Editor::NodeData& data,
        const TopologyRestrictions& restrictions);

    void operator () ();

    /// Do not preload objects and do not process linked edges
    void moveNodeOnly();

private:
    void processNodeMove();
    void snapEdgeSplit(const Edge& snapEdge);
    void checkRestrictions(const Node& node) const;

    NodeID nodeId_;
    geolib3::Point2 pos_;
    const TopologyRestrictions restrictions_;
};

} // namespace topo
} // namespace wiki
} // namespace maps
