#pragma once

#include <yandex/maps/wiki/topo/common.h>
#include <yandex/maps/wiki/topo/editor.h>

#include <maps/libs/geolib/include/point.h>
#include <maps/libs/geolib/include/polyline.h>

#include <vector>
#include <boost/optional.hpp>

namespace maps {
namespace wiki {
namespace topo {

class CacheImpl;

struct NodeUpdateData {
    NodeID nodeId;
    const geolib3::Point2* newPos;
};

struct EdgeUpdateData {
    OptionalEdgeID edgeId;
    const geolib3::Polyline2* newGeom;
};

struct TopologyUpdateData {
    TopologyUpdateData() = default;

    TopologyUpdateData(const Editor::TopologyData& data);

    TopologyUpdateData(const geolib3::PolylinesVector& geoms);

    TopologyUpdateData(
        std::vector<NodeUpdateData> nodesData,
        std::vector<EdgeUpdateData> edgesData);

    std::vector<NodeUpdateData> nodesData;
    std::vector<EdgeUpdateData> edgesData;
};

void
preloadObjects(
    CacheImpl& cache,
    const TopologyUpdateData& updateData,
    const TopologyRestrictions& restrictions);

} // namespace topo
} // namespace wiki
} // namespace maps
