#pragma once

#include "../events_data.h"
#include "../cache_impl.h"

#include <memory>

namespace maps {
namespace wiki {
namespace topo {

struct Callbacks;
class Edge;

class ProcessEvents {
public:
    ProcessEvents(CacheImpl& cache, const Callbacks& callbacks)
        : cache_(cache)
        , callbacks_(callbacks)
    {}

    void operator()(AddEdgeEventData& event);
    void operator()(DeleteEdgeEventData& event);
    void operator()(MoveEdgeEventData& event);

    // process event, but not send result
    void operator()(SplitEdgeEventData& event);
    void operator()(MergeEdgesEventData& event);
    void operator()(MergeNodesEventData& event);

private:
    void createNodesAtSplitPoints(SplitPointPtrVector& splitPoints,
        const boost::optional<IncidentNodes>& originalIncidences);

    void reuseNode(const SplitPointPtrVector& points, SplitPointPtr point, NodeID nodeId);

    void processMoveEvent(MoveEdgeEventData& event);

    CacheImpl& cache_;
    const Callbacks& callbacks_;
};

} // namespace topo
} // namespace wiki
} // namespace maps
