#include "save_edge.h"

#include "save_edge_helpers.h"
#include "preload_objects.h"
#include "process_events.h"
#include "../geom_tools/intersector.h"
#include "../geom_tools/geom_io.h"
#include "../index/spatial_index.h"
#include "../events_data.h"
#include "../editor_impl.h"
#include "../cache_impl.h"
#include "../graph.h"

#include <yandex/maps/wiki/topo/storage.h>
#include <yandex/maps/wiki/topo/events.h>
#include <yandex/maps/wiki/topo/exception.h>

#include <maps/libs/geolib/include/intersection.h>
#include <maps/libs/geolib/include/distance.h>
#include <maps/libs/geolib/include/vector.h>

#include <vector>
#include <algorithm>


namespace maps {
namespace wiki {
namespace topo {



using namespace geolib3;
using namespace geom;


SaveEdgeOperation::SaveEdgeOperation(
        const Callbacks& callbacks,
        CacheImpl& cache,
        const Editor::EdgeData& data,
        const TopologyRestrictions& restrictions)
    : Operation(callbacks, cache)
    , id_(data.id)
    , geom_(data.geom)
    , splits_(data.splitPoints)
    , restrictions_(restrictions)
{
    REQUIRE(!id_.exists() || id_.id(), "Invalid edge id");
}

void SaveEdgeOperation::operator () (bool loadObjects)
{
    geom_ = prepareGeometry(geom_);

    auto edgeId = boost::make_optional<EdgeID>(id_.exists(), id_.id());

    if (loadObjects) {
        TopologyUpdateData updateData{{}, {{edgeId, &geom_}}};
        preloadObjects(cache_, updateData, restrictions_);
    }

    // compute intersections
    boost::optional<IncidentNodes> oldIncidentNodes;
    if (id_.exists()) {
        const Edge& edge = cache_.graph().edge(id_.id());
        oldIncidentNodes = IncidentNodes(edge.startNode(), edge.endNode());
    }

    geom::Intersector intersector(
        cache_.graph(), restrictions_,
        [&] (NodeID nodeId) -> bool {
            return cache_.storage().nodeCanBeDeleted(nodeId);
        }
    );
    geom::Intersector::Events events = intersector(id_, geom_, splits_);

    REQUIRE(
        events.editedEdgeEvent->sourceId == id_,
        "Editing edge source id error, source id "
         << events.editedEdgeEvent->sourceId.id()
    );

    cache_.loadByNodes(events.unusedNodeIds);
    events.editedEdgeEvent->oldIncidentNodes = oldIncidentNodes;

    processEdgesSaving(cache_, callbacks_, events);
}

} // namespace topo
} // namespace wiki
} // namespace maps
